<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Delivery extends Model 
{

    protected $table = 'deliveries';
    public $timestamps = true;
    protected $fillable = array('date_delivrery', 'status_delivrery', 'command_id', 'service_id');
    protected $visible = array('date_delivrery', 'status_delivrery', 'command_id', 'service_id');

    public function services()
    {
        return $this->belongsTo('App\Models\Service');
    }

    public function commands()
    {
        return $this->belongsTo('App\Models\Command');
    }

}